package ru.yandex.direct.api.v5.validation;

import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.Path;

public class ApiDefect {

    private final int code;
    private final Translatable shortMessage;
    private final Translatable detailedMessage;

    public ApiDefect(DefectInfo<DefectType> defectInfo) {
        Path path = defectInfo.getPath();
        Object value = defectInfo.getValue();
        DefectType defectType = defectInfo.getDefect();
        this.code = defectType.getCode();
        this.shortMessage = defectType.getShortMessageProvider().getTranslatable(path, value);
        this.detailedMessage = defectType.getDetailedMessageProvider().getTranslatable(path, value);
    }

    public int getCode() {
        return code;
    }

    public Translatable getShortMessage() {
        return shortMessage;
    }

    public Translatable getDetailedMessage() {
        return detailedMessage;
    }
}
