package ru.yandex.direct.api.v5.validation;

import java.util.List;

import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class ApiDefectDefinitions {

    public static Defect maxIdsInSelection() {
        return new Defect<>(ApiDefectIds.Gen.MAX_IDS_IN_SELECTION);
    }

    // отдельная ошибка создана из-за текста детализации ошибки, ожидаемой в автотестах
    public static Defect maxIdsInSelectionVcard() {
        return new Defect<>(ApiDefectIds.Gen.MAX_IDS_IN_SELECTION_VCARD);
    }

    public static Defect incorrectPageNonPositiveLimit() {
        return new Defect<>(ApiDefectIds.Gen.LIMIT_MUST_BE_GREATER_THAN_ZERO);
    }

    public static Defect incorrectPageLimitExceeded(long max) {
        return new Defect<>(ApiDefectIds.Nums.LIMIT_MUST_BE_LESS_THAN_VALUE,
                new NumberDefectParams().withMax(max));
    }

    public static Defect incorrectPageNegativeOffset() {
        return new Defect<>(ApiDefectIds.Gen.OFFSET_MUST_BE_POSITIVE);
    }

    public static Defect incorrectPageOffsetExceeded(long max) {
        return new Defect<>(ApiDefectIds.Nums.OFFSET_MUST_BE_LESS_THAN_VALUE,
                new NumberDefectParams().withMax(max));
    }

    public static Defect arraySizeExceeded(long max) {
        return new Defect<>(ApiDefectIds.Nums.ARRAY_MUST_CONTAIN_LESS_THAN_VALUE,
                new NumberDefectParams().withMax(max));
    }

    public static Defect selectionCriteriaParamMissed(List<String> missedParams) {
        return new Defect<>(ApiDefectIds.Strings.SELECTION_CRITERIA_PARAM_MISSED,
                new StringsDefectParams().withStrings(missedParams));
    }

    public static Defect<CollectionSizeDefectParams> maxShowConditionsPerRequest(int max) {
        return new Defect<>(ApiDefectIds.CollectionIds.MAX_SHOW_CONDITIONS_PER_REQUEST,
                new CollectionSizeDefectParams().withMaxSize(max));
    }

    public static Defect<CollectionSizeDefectParams> maxAdGroupIdsPerRequest(int max) {
        return new Defect<>(ApiDefectIds.CollectionIds.MAX_AD_GROUP_IDS_PER_REQUEST,
                new CollectionSizeDefectParams().withMaxSize(max));
    }

    public static Defect<CollectionSizeDefectParams> maxCampaignIdsPerRequest(int max) {
        return new Defect<>(ApiDefectIds.CollectionIds.MAX_CAMPAIGN_IDS_PER_REQUEST,
                new CollectionSizeDefectParams().withMaxSize(max));
    }
}
