package ru.yandex.direct.api.v5.validation;

import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class ApiDefectIds {
    public enum Gen implements DefectId<Void> {
        MAX_IDS_IN_SELECTION,
        LIMIT_MUST_BE_GREATER_THAN_ZERO,
        OFFSET_MUST_BE_POSITIVE,
        MAX_IDS_IN_SELECTION_VCARD, // отдельная ошибка создана из-за текста детализации ошибки, ожидаемой в автотестах
    }

    public enum Strings implements DefectId<StringsDefectParams> {
        SELECTION_CRITERIA_PARAM_MISSED,
    }

    public enum Nums implements DefectId<NumberDefectParams> {
        LIMIT_MUST_BE_LESS_THAN_VALUE,
        OFFSET_MUST_BE_LESS_THAN_VALUE,
        ARRAY_MUST_CONTAIN_LESS_THAN_VALUE
    }

    public enum CollectionIds implements DefectId<CollectionSizeDefectParams> {
        MAX_SHOW_CONDITIONS_PER_REQUEST,
        MAX_AD_GROUP_IDS_PER_REQUEST,
        MAX_CAMPAIGN_IDS_PER_REQUEST
    }
}
