package ru.yandex.direct.api.v5.validation;

import java.util.Collection;

import org.springframework.util.StringUtils;

import ru.yandex.direct.api.v5.ApiErrorCodes;
import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;

public class DefectTypeCreators {
    @SuppressWarnings("WeakerAccess")
    public static DefectType wrongSelectionCriteria() {
        return new DefectType(ApiErrorCodes.WRONG_SELECTION_CRITERIA,
                CommonDefectTranslations.INSTANCE.invalidSelectionShort());
    }

    @SuppressWarnings("WeakerAccess")
    public static DefectType invalidRequestParams() {
        return DefectTypes.badParams();
    }

    public static DefectType wrongSelectionCriteriaUnsupportedFieldValues(String field, Collection<String> values) {
        String allowedValues = StringUtils.collectionToCommaDelimitedString(values);
        return wrongSelectionCriteria().withDetailedMessage(
                ApiFaultTranslations.INSTANCE.detailedUnsupportedFieldValues(field, allowedValues));
    }

    public static DefectType invalidRequestParamsInvalidDateFormat(String field) {
        return DefectTypeCreators.invalidRequestParams()
                .withDetailedMessage(ApiFaultTranslations.INSTANCE.detailedInvalidDateFormat(field));
    }

    public static DefectType invalidRequestParamsIncorrectDate(String field) {
        return DefectTypeCreators.invalidRequestParams()
                .withDetailedMessage(ApiFaultTranslations.INSTANCE.detailedIncorrectDate(field));
    }
}
