package ru.yandex.direct.api.v5.validation;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.region.RegionDesc;
import ru.yandex.direct.core.entity.region.TranslatableRegion;
import ru.yandex.direct.i18n.types.ConcatTranslatable;
import ru.yandex.direct.regions.Region;

import static ru.yandex.direct.api.v5.validation.DefectTypes.badGeo;
import static ru.yandex.direct.api.v5.validation.DefectTypes.translations;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class RegionIdsDefectTypes {

    public static DefectType geoEmptyRegions() {
        return badGeo().withDetailedMessage(translations().badGeoDetailedEmptyRegions());
    }

    public static DefectType geoIncorrectRegions(String incorrectRegions) {
        return badGeo().withDetailedMessage(
                translations().badGeoDetailedIncorrectRegions(incorrectRegions));
    }

    public static DefectType geoMinusRegionMatchesPlusRegion(Set<Long> positiveMatchedRegionIds) {
        return badGeo().withDetailedMessage(
                translations().badGeoDetailedMinusRegionMatchesPlusRegion(
                        String.join(",", mapList((mapList(positiveMatchedRegionIds, id -> -id)), Object::toString)),
                        String.join(",", mapList(positiveMatchedRegionIds, Object::toString))));
    }

    public static DefectType geoMinusRegionsWithoutPlusRegions(List<Region> minusRegionsNotInPlusRegions) {
        return badGeo().withDetailedMessage(translations()
                .badGeoDetailedMinusRegionsWithoutPlusRegions(
                        new ConcatTranslatable(", ", mapList(mapList(
                                minusRegionsNotInPlusRegions, RegionDesc::fromRegion), TranslatableRegion::new))));
    }

    public static DefectType geoNoPlusRegions() {
        return badGeo().withDetailedMessage(translations().badGeoDetailedNoPlusRegions());
    }

    public static DefectType geoNonUniqueRegions(List<Region> nonUniqueRegions) {
        return badGeo().withDetailedMessage(translations()
                .badGeoDetailedNonUniqueRegions(
                        new ConcatTranslatable(", ", mapList(mapList(
                                nonUniqueRegions, RegionDesc::fromRegion), TranslatableRegion::new))));

    }
}
