package ru.yandex.direct.api.v5.validation;

import java.util.List;
import java.util.Objects;

public class StringsDefectParams {
    private List<String> strings;

    public StringsDefectParams withStrings(List<String> strings) {
        this.strings = strings;
        return this;
    }

    public List<String> getStrings() {
        return strings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StringsDefectParams that = (StringsDefectParams) o;
        return Objects.equals(strings, that.strings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(strings);
    }

    @Override
    public String toString() {
        return "StringsDefectParams{" +
                "strings=" + strings +
                '}';
    }
}
