package ru.yandex.direct.api.v5.ws;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

import org.springframework.ws.transport.http.HttpServletConnection;

/**
 * Представляет http-транспорт для отправки SOAP и Json сообщений. В нашем случае
 * транспорт не поддерживает специальную обработку Fault-сообщений (См. DIRECT-69509)
 */
class ApiHttpServletConnection extends HttpServletConnection {
    ApiHttpServletConnection(HttpServletRequest httpServletRequest,
                             HttpServletResponse httpServletResponse) {
        super(httpServletRequest, httpServletResponse);
    }

    @Override
    public boolean hasFault() throws IOException {
        /*
         * Считаем, что наш транспорт не имеет механизмов для специальной обрабатки SOAP Fault-сообщений.
         * Необходимо чтобы в случае SOAP Fault-сообщений возвращался http статус 200, как в Perl-е (См. DIRECT-69509)
         */
        return false;
    }

    @Override
    public void setFault(boolean fault) throws IOException {
        /*
         * Считаем, что наш транспорт не имеет механизмов для специальной обрабатки SOAP Fault-сообщений. Поэтому
         * игнорируем попытку об сообщить ошибке. Необходимо чтобы в случае SOAP Fault-сообщений
         * возвращался http статус 200, как в Perl-е (См. DIRECT-69509)
         */
    }

    @Override
    public void setFaultCode(QName faultCode) throws IOException {
        /*
         * Считаем, что наш транспорт не имеет механизмов для специальной обрабатки SOAP Fault-сообщений, поэтому
         * игнорируем попытку об сообщить ошибке. Необходимо чтобы в случае SOAP Fault-сообщений
         * возвращался http статус 200, как в Perl-е (См. DIRECT-69509)
         */
    }
}
