package ru.yandex.direct.api.v5.ws;

import java.util.Locale;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

/**
 * Restrict resolved from HTTP header locale to the set of supported locales
 */
public class ApiLocaleResolver extends AcceptHeaderLocaleResolver {
    private final Locale defaultLocale;
    private final ImmutableSet<Locale> supported;

    public ApiLocaleResolver(Locale defaultLocale, Set<Locale> supported) {
        Preconditions.checkArgument(supported.contains(defaultLocale));
        this.defaultLocale = defaultLocale;
        this.supported = ImmutableSet.copyOf(supported);
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = super.resolveLocale(request);
        if (supported.contains(locale)) {
            return locale;
        } else {
            return defaultLocale;
        }
    }
}
