package ru.yandex.direct.api.v5.ws;

import org.springframework.ws.WebServiceMessage;

/**
 * Базовый класс для всех типов наших API сообщений
 */
public abstract class ApiMessage implements WebServiceMessage {
    protected String service;
    protected String operation;

    private Object apiRequestPayload;
    private Object apiResponsePayload;
    private Object apiFault;

    public String getService() {
        return service;
    }

    public String getOperation() {
        return operation;
    }

    public Object getApiRequestPayload() {
        return apiRequestPayload;
    }

    public void setApiRequestPayload(Object payload) {
        this.apiRequestPayload = payload;
    }

    public Object getApiResponsePayload() {
        return apiResponsePayload;
    }

    void setApiResponsePayload(Object apiResponsePayload) {
        this.apiResponsePayload = apiResponsePayload;
    }

    public void setApiFault(Object apiFault) {
        this.apiFault = apiFault;
    }

    public Object getApiFault() {
        return apiFault;
    }
}
