package ru.yandex.direct.api.v5.ws;

import org.springframework.web.servlet.HandlerAdapter;

/**
 * Правило, по которому выбирается делегат в {@link DelegatingWebServiceMessageReceiverHandlerAdapter}
 */
public class HandlerAdapterDelegateRule {
    private final String urlPrefix;
    private final HandlerAdapter handlerAdapter;

    public HandlerAdapterDelegateRule(String urlPrefix, HandlerAdapter handlerAdapter) {
        this.urlPrefix = urlPrefix;
        this.handlerAdapter = handlerAdapter;
    }

    public boolean isSuitableFor(String urlPath) {
        return urlPath.startsWith(this.urlPrefix);
    }

    public HandlerAdapter getHandlerAdapter() {
        return handlerAdapter;
    }
}
