package ru.yandex.direct.api.v5.ws;

import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpServletConnection;

@Component
public class RequestUriProvider {
    private final UrlPathHelper urlPathHelper;

    public RequestUriProvider() {
        urlPathHelper = new UrlPathHelper();
    }

    public Optional<String> getRequestUri() {
        TransportContext ctx = TransportContextHolder.getTransportContext();
        if (ctx == null) {
            return Optional.empty();
        }

        HttpServletRequest request = ((HttpServletConnection) ctx.getConnection()).getHttpServletRequest();
        if (request == null) {
            return Optional.empty();
        }

        return Optional.of(urlPathHelper.getRequestUri(request));
    }
}
