package ru.yandex.direct.api.v5.ws;

import java.io.IOException;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.context.ApiContext;
import ru.yandex.direct.api.v5.context.ApiContextHolder;

/**
 * Сохраняет HTTP ответ в {@link ApiContext}.
 */
@Component
@ParametersAreNonnullByDefault
public class SetApiResponseToContextFilter implements Filter {

    private final ApiContextHolder apiContextHolder;

    @Autowired
    public SetApiResponseToContextFilter(ApiContextHolder apiContextHolder) {
        this.apiContextHolder = apiContextHolder;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // no initialization
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        apiContextHolder.get().setApiResponse((HttpServletResponse) response);

        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        // no finalization
    }

}
