package ru.yandex.direct.api.v5.ws.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.api.v5.ws.enpointmapping.ApiMethodEndpointMapping;

/**
 * Marks an endpoint method as the handler for an incoming json request.
 *
 * @see ApiMethodEndpointMapping
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiMethod {
    String service();

    String operation();
}
