package ru.yandex.direct.api.v5.ws.enpointmapping;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;

/**
 * The key to mapping to methods with defined service and method name
 */
class ApiMethodEndpointMappingKey extends Pair<String, String> {
    private final String service;
    private final String operation;

    ApiMethodEndpointMappingKey(String service, String operation) {
        this.service = service;
        this.operation = operation;
    }

    public String getService() {
        return service;
    }

    public String getOperation() {
        return operation;
    }

    @Override
    public String getLeft() {
        return getService();
    }

    @Override
    public String getRight() {
        return getOperation();
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
