package ru.yandex.direct.api.v5.ws.exceptionresolver;

import java.util.Optional;

import org.springframework.core.Ordered;

/**
 * Provides method to translate any supported exception to another exception.
 */
public interface ExceptionTranslator {

    int NON_DEFAULT_TRANSLATOR_ORDER = 0;
    int DEFAULT_TRANSLATOR_ORDER = Ordered.LOWEST_PRECEDENCE;

    /**
     * Translates the given exception to another one.
     *
     * @param ex exception that need to be translated.
     * @return {@link Optional} with value, if translator supports passed {@link Exception} type,
     * empty otherwise.
     */
    Optional<? extends Exception> translate(Exception ex);
}
