package ru.yandex.direct.api.v5.ws.exceptionresolver;

import javax.xml.namespace.QName;

import org.springframework.ws.WebServiceMessage;

/**
 * Interface for fault response creator that knows how to create error response at the message of specific type
 * Provides to {@link ApiExceptionResolver} ability to create error response at the different message types
 *
 * @see ApiExceptionResolver
 * @see ru.yandex.direct.api.v5.ws.json.JsonMessage
 * @see org.springframework.ws.soap.SoapMessage
 */
public interface FaultResponseCreator {
    /**
     * Indicates whether the given {@link WebServiceMessage} can be processed by this creator.
     *
     * @param response the instance of web service message
     * @return {@code true} if this creator is able to create error response at given web service message
     * {@code false} otherwise
     */
    boolean support(WebServiceMessage response);

    /**
     * Creates error response at given message
     *
     * @param response      web service message for response
     * @param faultMessage  fault message
     * @param webFaultQName {@link QName} for detail in soap fault
     * @param faultInfo     bean that represents detail fault info for soap fault
     */
    void createFaultResponse(WebServiceMessage response, String faultMessage,
                             QName webFaultQName, Object faultInfo);
}
