package ru.yandex.direct.api.v5.ws.json;

import java.util.function.Consumer;
import java.util.function.Supplier;

import javax.xml.transform.Result;
import javax.xml.transform.Source;

import org.springframework.ws.WebServiceMessage;


/**
 * This is the hack to store payload of JSON message at the child of
 * {@link WebServiceMessage}
 */
public class ObjectSourceAndResult implements Source, Result {
    private final Consumer<Object> setter;
    private final Supplier<Object> getter;

    public ObjectSourceAndResult(Supplier<Object> getter, Consumer<Object> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public Object getObject() {
        return getter.get();
    }

    public void setObject(Object payloadObject) {
        setter.accept(payloadObject);
    }

    @Override
    public void setSystemId(String systemId) {
    }

    @Override
    public String getSystemId() {
        return null;
    }
}
