package ru.yandex.direct.api.v5.ws.soap;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Function;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamSource;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.AttachmentException;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapBodyException;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.transport.TransportOutputStream;
import org.w3c.dom.Document;

import ru.yandex.direct.api.v5.ws.ApiMessage;
import ru.yandex.direct.tracing.Trace;

import static ru.yandex.direct.api.v5.ws.WsConstants.HEADER_REQUEST_ID;


public class SoapMessage extends ApiMessage implements org.springframework.ws.soap.SoapMessage, MimeMessage {
    private final SaajSoapMessage saajSoapMessage;
    private final Function<String, String> getServiceFromSoapAction;
    private final Function<String, String> getOperationFromSoapAction;

    public SoapMessage(SaajSoapMessage saajSoapMessage,
                       Function<String, String> getServiceFromSoapAction,
                       Function<String, String> getOperationFromSoapAction) {
        this.saajSoapMessage = saajSoapMessage;
        this.getServiceFromSoapAction = getServiceFromSoapAction;
        this.getOperationFromSoapAction = getOperationFromSoapAction;
    }

    public SOAPMessage getSaajMessage() {
        return saajSoapMessage.getSaajMessage();
    }

    public void setSaajMessage(SOAPMessage soapMessage) {
        saajSoapMessage.setSaajMessage(soapMessage);
    }

    @Override
    public SoapEnvelope getEnvelope() {
        return saajSoapMessage.getEnvelope();
    }

    @Override
    public String getSoapAction() {
        return saajSoapMessage.getSoapAction();
    }

    @Override
    public void setSoapAction(String soapAction) {
        saajSoapMessage.setSoapAction(soapAction);
    }

    @Override
    public Document getDocument() {
        return saajSoapMessage.getDocument();
    }

    @Override
    public void setDocument(Document document) {
        saajSoapMessage.setDocument(document);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream instanceof TransportOutputStream) {
            TransportOutputStream transportOutputStream = (TransportOutputStream) outputStream;
            transportOutputStream.addHeader(HEADER_REQUEST_ID, String.valueOf(Trace.current().getSpanId()));
        }
        saajSoapMessage.writeTo(outputStream);
    }

    @Override
    public boolean isXopPackage() {
        return saajSoapMessage.isXopPackage();
    }

    @Override
    public boolean convertToXopPackage() {
        return saajSoapMessage.convertToXopPackage();
    }

    @Override
    public Iterator<Attachment> getAttachments() throws AttachmentException {
        return saajSoapMessage.getAttachments();
    }

    @Override
    public Attachment getAttachment(String contentId) {
        return saajSoapMessage.getAttachment(contentId);
    }

    @Override
    public Attachment addAttachment(String contentId, DataHandler dataHandler) {
        return saajSoapMessage.addAttachment(contentId, dataHandler);
    }

    @Override
    public String toString() {
        return saajSoapMessage.toString();
    }

    @Override
    public SoapVersion getVersion() {
        return saajSoapMessage.getVersion();
    }

    @Override
    public Attachment addAttachment(String contentId, File file) throws AttachmentException {
        return saajSoapMessage.addAttachment(contentId, file);
    }

    @Override
    public Attachment addAttachment(String contentId, InputStreamSource inputStreamSource, String contentType) {
        return saajSoapMessage.addAttachment(contentId, inputStreamSource, contentType);
    }

    @Override
    public Source getPayloadSource() {
        return saajSoapMessage.getPayloadSource();
    }

    @Override
    public Result getPayloadResult() {
        return saajSoapMessage.getPayloadResult();
    }

    @Override
    public SoapBody getSoapBody() throws SoapBodyException {
        return saajSoapMessage.getSoapBody();
    }

    @Override
    public SoapHeader getSoapHeader() throws SoapHeaderException {
        return saajSoapMessage.getSoapHeader();
    }

    @Override
    public boolean hasFault() {
        return saajSoapMessage.hasFault();
    }

    @Override
    public QName getFaultCode() {
        return saajSoapMessage.getFaultCode();
    }

    @Override
    public String getFaultReason() {
        return saajSoapMessage.getFaultReason();
    }

    @Override
    public String getService() {
        try {
            return getServiceFromSoapAction.apply(getUrlPathFromSoapAction());
        } catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getOperation() {
        try {
            return getOperationFromSoapAction.apply(getUrlPathFromSoapAction());
        } catch (MalformedURLException e) {
            return null;
        }
    }

    private String getUrlPathFromSoapAction() throws MalformedURLException {
        // soap action may be in quotes
        String soapAction = StringUtils.strip(getSoapAction(), "\"");
        return new URL(soapAction).getPath();
    }
}
