package ru.yandex.direct.api.v5.ws.validation;

import ru.yandex.direct.api.v5.ApiErrorCodes;
import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.i18n.Translatable;


/**
 * Общая ошибка некорректного объекта в запросе.
 */
public class IncorrectRequestApiException extends TranslatableException {
    public IncorrectRequestApiException() {
        super(ApiErrorCodes.BAD_REQUEST, ApiFaultTranslations.INSTANCE.incorrectRequest(),
                ApiFaultTranslations.INSTANCE.detailedIncorrectRequestFormat());
    }

    public IncorrectRequestApiException(Translatable detailedMessage) {
        super(ApiErrorCodes.BAD_REQUEST, ApiFaultTranslations.INSTANCE.incorrectRequest(), detailedMessage);
    }

    public IncorrectRequestApiException(Throwable cause, Translatable detailedMessage) {
        super(cause, ApiErrorCodes.BAD_REQUEST, ApiFaultTranslations.INSTANCE.incorrectRequest(), detailedMessage);
    }
}
