package ru.yandex.direct.api.v5.ws.validation;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.i18n.Translatable;

/**
 * Ошибка несоответствия размера какого-либо массива в запросе, ограничениям описанным в WSDL
 */
public class InvalidSizeApiException extends IncorrectRequestApiException {
    public InvalidSizeApiException(String path, int min, int max) {
        super(detailedMessage(path, min, max));
    }

    private static Translatable detailedMessage(String path, int min, int max) {
        if (min == 0) {
            return ApiFaultTranslations.INSTANCE.detailedInvalidMaxSize(path, max);
        } else if (max == Integer.MAX_VALUE) {
            return ApiFaultTranslations.INSTANCE.detailedInvalidMinSize(path, min);
        } else {
            return ApiFaultTranslations.INSTANCE.detailedInvalidSize(path, min, max);
        }
    }
}
