package ru.yandex.direct.api.v5.ws.validation;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import com.fasterxml.jackson.databind.JsonMappingException;

/**
 * Утилиты для работы с ошибками биндинга, выкидываемыми Jackson
 */
public class JacksonUtil {
    /**
     * Возвращает путь к ошибке в документе запроса
     *
     * @param ex ошибка биндинга, возникшая при десериализации
     * @return строка пути к ошибке в документе
     */
    public static String getMappingExceptionPath(JsonMappingException ex) {
        List<JsonMappingException.Reference> referencePath = ex.getPath();
        return mappingPathToString(referencePath);
    }

    static String mappingPathToString(Iterable<JsonMappingException.Reference> referencePath) {
        return StreamSupport.stream(referencePath.spliterator(), false)
                .map(JsonMappingException.Reference::getFieldName)
                .filter(Objects::nonNull)
                .collect(Collectors.joining("."));
    }
}
