package ru.yandex.direct.api.v5.ws.validation;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonMappingException;

/**
 * Удобное представление пути до элемента с ошибкой в виде пути до родительского списка
 * и пути до поля элемента из этого списка.
 */
@ParametersAreNonnullByDefault
class PathWithArrayPrefix {
    private List<JsonMappingException.Reference> prefixArrayPath;
    private List<JsonMappingException.Reference> inArrayPath;

    private PathWithArrayPrefix(List<JsonMappingException.Reference> prefixArrayPath,
                                List<JsonMappingException.Reference> inArrayPath) {
        this.prefixArrayPath = prefixArrayPath;
        this.inArrayPath = inArrayPath;
    }

    static PathWithArrayPrefix fromPath(List<JsonMappingException.Reference> path) {
        int parentArrayItemIdx = -1;
        for (int i = path.size() - 1; i >= 0; i--) {
            // для Reference это условие того, что нода является индексом в списке
            if (path.get(i).getIndex() >= 0) {
                parentArrayItemIdx = i;
                break;
            }
        }
        List<JsonMappingException.Reference> prefixArrayPath = path.subList(0, parentArrayItemIdx + 1);
        List<JsonMappingException.Reference> inArrayPath = path.subList(parentArrayItemIdx + 1, path.size());
        return new PathWithArrayPrefix(prefixArrayPath, inArrayPath);
    }

    @Nonnull
    List<JsonMappingException.Reference> getPrefixArrayPath() {
        return prefixArrayPath;
    }

    @Nonnull
    List<JsonMappingException.Reference> getInArrayPath() {
        return inArrayPath;
    }
}
