package ru.yandex.direct.api.v5.ws.validation;

import java.util.List;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;

import ru.yandex.direct.api.v5.ApiFaultTranslations;
import ru.yandex.direct.i18n.Translatable;

/**
 * Ошибка, выдаваемая в случае обнаружения неизвестного поля в документе запроса
 */
public class UnknownParameterApiException extends IncorrectRequestApiException {

    private UnknownParameterApiException(Throwable cause, Translatable detailedMessage) {
        super(cause, detailedMessage);
    }

    /**
     * Возвращается {@link UnknownParameterApiException}. В сообщение об ошибке попадает информация о том,
     * является ли объект с неизвестным параметром элементом некоторого списка или нет.
     */
    public static UnknownParameterApiException fromJacksonUnrecognizedPropertyException(
            UnrecognizedPropertyException ex) {
        // Подробнее про то, зачем разбираем путь до поля с ошибкой, в
        // DIRECT-70194: Более понятные сообщения в ошибках парсинга

        List<JsonMappingException.Reference> path = ex.getPath();
        PathWithArrayPrefix pathWithArrayPrefix = PathWithArrayPrefix.fromPath(path);
        if (!pathWithArrayPrefix.getPrefixArrayPath().isEmpty()) {
            String arrayPathText = JacksonUtil.mappingPathToString(pathWithArrayPrefix.getPrefixArrayPath());
            String field = JacksonUtil.mappingPathToString(pathWithArrayPrefix.getInArrayPath());
            return new UnknownParameterApiException(ex,
                    ApiFaultTranslations.INSTANCE.detailedUnknownParameterInArray(arrayPathText, field));
        }
        String parameterPath = JacksonUtil.getMappingExceptionPath(ex);
        return new UnknownParameterApiException(ex,
                ApiFaultTranslations.INSTANCE.detailedUnknownParameter(parameterPath));
    }

}
