package ru.yandex.direct.api.v5.ws.validation;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import javax.validation.Path;

import org.apache.commons.lang3.text.WordUtils;

/**
 * Утилиты для работы с объектами из {@code javax.validation}.
 */
class ValidationUtil {

    private ValidationUtil() {
    }

    /**
     * Возвращает представление пути {@code path} в виде строки
     */
    static String simpleViolationPathConverter(Path path) {
        // Здесь нужно сконвертировать путь к ошибке на объекте, в путь ошибки на исходном документе (Xml/Json)
        // Пользуясь тем, что в исходном документе все элементы отличаются только заглавной буквой от
        // полей бина, просто делаем capitalize.
        // Альтернативный, более правильный подход: брать названия из аннотаций @XmlElement на классе объекта.
        return StreamSupport.stream(path.spliterator(), false)
                .map(Path.Node::getName)
                .map(WordUtils::capitalize)
                .collect(Collectors.joining("."));
    }
}
