package ru.yandex.direct.api.v5.ws.validation;

/**
 * Константы, необходимые для разбора WSDL и валидации по нему
 */
class WsdlConstants {
    private WsdlConstants() {}

    static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    static final String XMLSCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";

    static final String TARGET_NAMESPACE = "targetNamespace";
    static final String SCHEMA = "schema";
    static final String PORT_TYPE = "portType";
    static final String OPERATION = "operation";
    static final String INPUT = "input";
    static final String PART = "part";
    static final String COMPLEX_TYPE = "complexType";
    static final String SEQUENCE = "sequence";
    static final String COMPLEX_CONTENT = "complexContent";
    static final String EXTENSION = "extension";
    static final String ELEMENT = "element";

    static final String XMLNS_PREFIX = "xmlns:";

    static final String NAME = "name";
    static final String TYPE = "type";
    static final String NILLABLE = "nillable";
    static final String MIN_OCCURS = "minOccurs";
    static final String MAX_OCCURS = "maxOccurs";
    static final String BASE = "base";
    static final String MESSAGE = "message";
}
