package ru.yandex.direct.api.v5.ws.validation;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Strings;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static java.lang.Integer.parseInt;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.BASE;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.MAX_OCCURS;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.MIN_OCCURS;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.NAME;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.NILLABLE;
import static ru.yandex.direct.api.v5.ws.validation.WsdlConstants.TYPE;

/**
 * Необходиые данные для валидации элемента данных по WSDL-схеме
 */
@ParametersAreNonnullByDefault
class WsdlElement {
    private String namespace;
    private String tag;
    private List<WsdlElement> children;

    private String name;
    private String type;
    private boolean nillable;
    private Integer minOccurs;
    private Integer maxOccurs;
    private String base;

    WsdlElement(String namespace, Element element) {
        this.namespace = namespace;
        this.tag = element.getTagName();
        this.name = element.getAttribute(NAME);
        this.type = element.getAttribute(TYPE);
        this.nillable = "true".equals(element.getAttribute(NILLABLE));
        this.minOccurs = parseOccurs(element.getAttribute(MIN_OCCURS));
        this.maxOccurs = parseOccurs(element.getAttribute(MAX_OCCURS));
        this.base = element.getAttribute(BASE);

        this.children = new ArrayList<>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); i++) {
            if (childNodes.item(i) instanceof Element) {
                this.children.add(new WsdlElement(namespace, (Element) childNodes.item(i)));
            }
        }
    }

    String getNamespace() {
        return namespace;
    }

    String getTag() {
        return tag;
    }

    List<WsdlElement> getChildren() {
        return children;
    }

    String getName() {
        return name;
    }

    String getType() {
        return type;
    }

    boolean isNillable() {
        return nillable;
    }

    Integer getMinOccurs() {
        return minOccurs;
    }

    Integer getMaxOccurs() {
        return maxOccurs;
    }

    String getBase() {
        return base;
    }

    private int parseOccurs(@Nullable String attr) {
        if (Strings.isNullOrEmpty(attr)) {
            return 1;
        }
        if (attr.equals("unbounded")) {
            return Integer.MAX_VALUE;
        }
        return parseInt(attr);
    }
}
