package ru.yandex.direct.api.v5.entity.audiencetargets.delegate;

import java.util.List;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.audiencetargets.converter.AudienceTargetsHelperConverter;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.user.model.ApiUser;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.singletonList;
import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static ru.yandex.direct.api.v5.validation.AssertJMatcherAdaptors.hasNoDefects;

public class AddAudienceTargetsDelegateTest {

    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();

    @Mock
    private ApiAuthenticationSource auth;

    @Mock
    private AdGroupService adGroupService;

    private AddAudienceTargetsDelegate delegate;

    private static final ClientId CLIENT_ID = ClientId.fromLong(1L);
    private static final Long ADGROUP_ID = 1L;

    @Before
    public void before() {
        when(auth.getChiefSubclient()).thenReturn(new ApiUser().withClientId(CLIENT_ID));

        when(adGroupService.getAdGroupTypes(eq(CLIENT_ID), eq(ImmutableSet.of(ADGROUP_ID))))
                .thenReturn(ImmutableMap.of(ADGROUP_ID, AdGroupType.CPM_VIDEO));

        delegate = new AddAudienceTargetsDelegate(
                auth,
                mock(AudienceTargetsHelperConverter.class),
                mock(RetargetingService.class),
                mock(ResultConverter.class),
                adGroupService,
                mock(PpcPropertiesSupport.class),
                mock(FeatureService.class)
        );
    }

    @Test
    public void validateInternalRequest_CpmVideoAdGroup_Ok() {
        ValidationResult<List<TargetInterest>, DefectType> vr = delegate.validateInternalRequest(singletonList(
                new TargetInterest().withAdGroupId(ADGROUP_ID)));

        assertThat(vr).as("Тип cpm_video поддерживается в методе audiencetargets.add").is(hasNoDefects());
    }
}
