# -*- coding: utf-8 -*-

import logging
import os
import requests
import tempfile
import yatest.common
from ut_utils import PythonTest
from xml.etree import ElementTree as ET

import json


class Test(PythonTest):
    @classmethod
    def logger(cls):
        return logging.getLogger("test_logger")

    @classmethod
    def tar_paths(cls):
        return ["direct/api5/yandex-direct-api5.tar"]

    @classmethod
    def java_class_name(cls):
        return 'ru.yandex.direct.api.v5.YandexDirectApiV5Application'

    @classmethod
    def setup_class(cls):
        cls.tmp_token_file = tempfile.NamedTemporaryFile()
        cls.tmp_token_file.file.write(b"super_secret")
        cls.tmp_token_file.file.flush()
        super(Test, cls).setup_class()

    @classmethod
    def teardown_class(cls):
        os.unlink(cls.tmp_token_file.name)
        super(Test, cls).teardown_class()

    @classmethod
    def java_args(cls):
        return [
            "-Dyandex.environment.type=production",
            "-Ddb_config=classpath:///db-config.db_testing.json",
            "-Dnetwork_config=classpath:///network-config.allow-all.json",
            "-Dsendmail.yservice_salt_file_url=classpath:sendmail-yservice-salt.txt",
            "-Dsendmail.hmac_salt_file_url=classpath:sendmail-hmac-salt.txt",
            "-Dmds.direct_files.token_file_url=classpath:///mds-auth-testing.txt",
            "-Dtvm.secret=memory://top_secret",
            "-Dtvm.enabled=false",
            "-Dcanvas.file=" + cls.tmp_token_file.name,
            "-Dturbo_landings.file=" + cls.tmp_token_file.name,
            "-Dredis_cache.name=redis",
            "-Ddssclient.user_credentials_file_url=classpath:dss-user-credentials-dummy.json",
            "-Ddssclient.client_credentials_file_url=classpath:dss-client-credentials-dummy.json",
            "-Djetty.port=" + str(cls.get_server_port()),
            "-Djetty.ssl_port=0",
            "-DLOG_ROOT=" + yatest.common.output_path(""),
            "-Dmediascope_client.settings_salt_token_path=memory://m_secret",
            "-Dmediascope_client.client_id_path=memory://direct",
            "-Dmediascope_client.client_secret_path=memory://password",
            "-Dbannerstorage_api.url=http://not_real_host",
            "-Dbannerstorage_api.token=top_secret",
            "-Ddisplay.landing.auth_token=memory://secret_token",
            "-Dstartrek.robot_direct_daas.token_file=memory://secret_token",
            "-Dobject_api.service_holder.token=memory://fake_secret",
            ]

    def test_alive(self):
        """ Base url отвечает статикой """
        resp = requests.get(self.get_base_url())
        if resp.ok:
            assert resp.text == "Yandex.Direct API - https://tech.yandex.ru/direct/"
        else:
            assert resp.status_code == 500

    def test_get_wsdl(self):
        """ Попытка получить доступный без авторизации WSDL """
        resp = requests.get(self.get_base_url() + "v5/keywords?wsdl")
        assert resp.ok
        ET.fromstring(resp.content)

    def test_vcard_oauth_error(self):
        """ Попытка получить ответ без OAuth-токена """
        data = {"method": "get"}
        resp = requests.post(self.get_base_url() + "json/v5/vcards", data=json.dumps(data))
        assert json.loads(resp.content).get("error").get("error_code") == 8000
