JAVA_PROGRAM(yandex-direct-api5)

WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/direct/libs/common.inc)
OWNER(g:direct)

JAVAC_FLAGS(
    # https://st.yandex-team.ru/DIRECT-163072
    -J-Xss4M
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

PEERDIR(
    direct/common
    direct/core
#    direct/libs/tracing
    direct/libs/interruption
    direct/libs/redis-lock
    direct/libs/i18n
    direct/libs/jcommander-utils
    direct/libs/advq-client
    direct/libs/display-landing-client
    direct/libs/solomon
    direct/libs-internal/web-auth
    direct/libs-internal/web-core
    direct/libs-internal/yt-core

    iceberg/inside-passport

    contrib/java/com/google/code/findbugs/jsr305

    # Spring
    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-context
    contrib/java/org/springframework/spring-web
    contrib/java/org/springframework/spring-webmvc
    contrib/java/org/springframework/spring-aop
    contrib/java/org/springframework/spring-beans
    contrib/java/org/springframework/spring-oxm

    # Spring Security
    contrib/java/org/springframework/security/spring-security-core
    contrib/java/org/springframework/security/spring-security-web

    # Spring WS
    contrib/java/org/springframework/ws/spring-ws-core/2.3.0.RELEASE
    contrib/java/wsdl4j/wsdl4j/1.6.3

    contrib/java/com/google/guava/guava

    # Jackson
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/module/jackson-module-jaxb-annotations
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml

    #contrib/java/com/fasterxml/woodstox/woodstox-core/5.0.3

    # JDK10
    contrib/java/javax/xml/ws/jaxws-api
    contrib/java/javax/xml/soap/javax.xml.soap-api/1.4.0
    contrib/java/com/sun/xml/ws/jaxws-ri

    contrib/java/org/apache/commons/commons-collections4
)

# --------- CODE GENERATION ---------

SET(
    WSIMPORT_ARGS
    -s ${BINDIR}/generated
    -B-Xfluent-api
    # плагин meta из contrib/java/net/codesup/util/jaxb2-rich-contract-plugin/1.18.0 понимает,
    # что его аргументы закончились, только когда видит что-то на -X, поэтому такой странный порядок
    -B-Xmeta -generateTools=y -extended=y
    -Xnocompile
    -B-Xsetters -B-Xsetters-mode=direct
    -B-XReplacePrimitives
    -B-XJsr303Annotations
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/AudienceTargets.wsdl
    IN src/main/resources/wsdl/AudienceTargets.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/KeywordsResearch.wsdl
    IN src/main/resources/wsdl/KeywordsResearch.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Keywords.wsdl
    IN src/main/resources/wsdl/Keywords.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/RetargetingLists.wsdl
    IN src/main/resources/wsdl/RetargetingLists.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Bids.wsdl
    IN src/main/resources/wsdl/Bids.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/KeywordBids.wsdl
    IN src/main/resources/wsdl/KeywordBids.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Clients.wsdl
    IN src/main/resources/wsdl/Clients.wsdl src/main/resources/wsdl/general.xsd src/main/resources/wsdl/generalclients.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/AgencyClients.wsdl
    IN src/main/resources/wsdl/AgencyClients.wsdl src/main/resources/wsdl/general.xsd src/main/resources/wsdl/generalclients.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/VCards.wsdl
    IN src/main/resources/wsdl/VCards.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Sitelinks.wsdl
    IN src/main/resources/wsdl/Sitelinks.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/TurboPages.wsdl
    IN src/main/resources/wsdl/TurboPages.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/AdGroups.wsdl
    IN src/main/resources/wsdl/AdGroups.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Campaigns.wsdl
    IN src/main/resources/wsdl/Campaigns.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/CampaignsExt.wsdl
    IN src/main/resources/wsdl/CampaignsExt.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/BidModifiers.wsdl
    IN src/main/resources/wsdl/BidModifiers.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Creatives.wsdl
    IN src/main/resources/wsdl/Creatives.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/AdExtensions.wsdl
    IN src/main/resources/wsdl/AdExtensions.wsdl src/main/resources/wsdl/general.xsd
    IN src/main/resources/wsdl/AdExtensions.wsdl src/main/resources/wsdl/adextensiontypes.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Ads.wsdl
    IN src/main/resources/wsdl/Ads.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Leads.wsdl
    IN src/main/resources/wsdl/Leads.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Dictionaries.wsdl
    IN src/main/resources/wsdl/Dictionaries.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/DynamicTextAdTargets.wsdl
    IN src/main/resources/wsdl/DynamicTextAdTargets.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/DynamicFeedAdTargets.wsdl
    IN src/main/resources/wsdl/DynamicFeedAdTargets.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/NegativeKeywordSharedSets.wsdl
    IN src/main/resources/wsdl/NegativeKeywordSharedSets.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Features.wsdl
    IN src/main/resources/wsdl/Features.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Businesses.wsdl
    IN src/main/resources/wsdl/Businesses.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/SmartAdTargets.wsdl
    IN src/main/resources/wsdl/SmartAdTargets.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/PromotedContent.wsdl
    IN src/main/resources/wsdl/PromotedContent.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Feeds.wsdl
    IN src/main/resources/wsdl/Feeds.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Changes.wsdl
    IN src/main/resources/wsdl/Changes.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/AdVideos.wsdl
    IN src/main/resources/wsdl/AdVideos.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/wsdl/Strategies.wsdl
    IN src/main/resources/wsdl/Strategies.wsdl src/main/resources/wsdl/general.xsd
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

END()

RECURSE_FOR_TESTS(
    ut
    ut-run
    ut-configuration
    ut-grut
)
