package ru.yandex.direct.binlogbroker.logbroker_utils.models;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.model.BinlogEvent;

/**
 * Пара событие-offset. Offset приезжает из логброкера вместе с записью.
 * Гарантируется, что offset строго возрастает внутри одного topic логброкера.
 * Используется для проверки того, нужно ли обрабатывать конкретный {@link BinlogEvent}.
 */
@ParametersAreNonnullByDefault
public class BinlogEventWithOffset {
    private final BinlogEvent event;
    private final long offset;
    private final int partition;
    private final long seqNo;

    public BinlogEventWithOffset(BinlogEvent event, long offset, int partition, long seqNo) {
        this.event = event;
        this.offset = offset;
        this.partition = partition;
        this.seqNo = seqNo;
    }

    public BinlogEvent getEvent() {
        return event;
    }

    public long getOffset() {
        return offset;
    }

    public int getPartition() {
        return partition;
    }

    public long getSeqNo() {
        return seqNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BinlogEventWithOffset that = (BinlogEventWithOffset) o;
        return offset == that.offset &&
                partition == that.partition &&
                seqNo == that.seqNo &&
                Objects.equals(event, that.event);
    }

    @Override
    public int hashCode() {
        return Objects.hash(event, offset, partition, seqNo);
    }

    @Override
    public String toString() {
        return "BinlogEventWithOffset{" +
                "event=" + event +
                ", offset=" + offset +
                ", partition=" + partition +
                ", seqNo=" + seqNo +
                '}';
    }

}
