package ru.yandex.direct.binlogbroker.logbroker_utils.models;

import java.nio.file.Paths;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.utils.io.FileUtils;

@ParametersAreNonnullByDefault
public class LogbrokerCredentialsConfig {
    private String tvmSecretPath = null;
    private int tvmClientId = -1;
    private int tvmDstClientId = -1;

    @Parameter(
            names = {"--logbroker-tvm-secret-path"}
    )
    public void setTvmSecretPath(String tvmSecretPath) {
        this.tvmSecretPath = tvmSecretPath;
    }

    @Nullable
    public String getTvmSecret() {
        if (this.tvmSecretPath == null) {
            return null;
        } else {
            return FileUtils.slurp(Paths.get(this.tvmSecretPath)).trim();
        }
    }

    @Parameter(
            names = {"--logbroker-tvm-client-id"}
    )
    public void setTvmClientId(int tvmClientId) {
        this.tvmClientId = tvmClientId;
    }

    public int getTvmClientId() {
        return this.tvmClientId;
    }

    @Parameter(
            names = {"--logbroker-tvm-dst-client-id"},
            description = "TVM Id of Logbroker instance; use 2001147 for logbroker-pre and 2001059 for prod"
    )
    public void setTvmDstClientId(int tvmDstClientId) {
        this.tvmDstClientId = tvmDstClientId;
    }

    public int getTvmDstClientId() {
        return this.tvmDstClientId;
    }
}
