package ru.yandex.direct.binlogbroker.logbroker_utils.reader;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.Interrupts;

@ParametersAreNonnullByDefault
public interface LogbrokerBatchReader<T> extends AutoCloseable {

    default void fetchEvents(Interrupts.InterruptibleConsumer<List<T>> eventsConsumer)
            throws InterruptedException {
        fetchEvents(events -> {
            eventsConsumer.accept(events);
            return LogbrokerCommitState.NEED_COMMIT;
        });
    }

    void fetchEvents(Interrupts.InterruptibleFunction<List<T>, LogbrokerCommitState> eventsConsumer)
            throws InterruptedException;

    @Override
    void close() throws LogbrokerReaderCloseException;
}
