package ru.yandex.direct.binlogbroker.logbroker_utils.writer;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.kikimr.persqueue.producer.AsyncProducer;

public class BatchLogbrokerWriter<D> extends AbstractLogbrokerWriterImpl<List<D>> {

    private final Function<List<D>, LogbrokerWriteRequest> serializer;

    public BatchLogbrokerWriter(Supplier<CompletableFuture<AsyncProducer>> logbrokerProducerSupplier,
                                Duration logbrokerTimeout,
                                int retryCount,
                                Function<List<D>, LogbrokerWriteRequest> serializer) {
        super(logbrokerProducerSupplier, logbrokerTimeout, new LogbrokerWriterRetryConfig(retryCount));
        this.serializer = serializer;
    }

    @Override
    protected LogbrokerWriteRequest makeRequest(List<D> record) {
        return serializer.apply(record);
    }
}
