package ru.yandex.direct.binlogbroker.logbroker_utils.writer;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;

import static java.nio.charset.StandardCharsets.UTF_8;

@ParametersAreNonnullByDefault
public class JsonLogbrokerWriter<D> extends AbstractLogbrokerWriterImpl<D> {

    private static final Logger logger = LoggerFactory.getLogger(JsonLogbrokerWriter.class);

    public JsonLogbrokerWriter(Supplier<CompletableFuture<AsyncProducer>> logbrokerProducerSupplier,
                               Duration logbrokerTimeout,
                               int retryCount) {
        super(logbrokerProducerSupplier, logbrokerTimeout, new LogbrokerWriterRetryConfig(retryCount));
    }

    @Override
    protected LogbrokerWriteRequest makeRequest(D record) {
        String jsonRequest = JsonUtils.toJson(record);
        logger.info("Sending request {}", jsonRequest);
        return new LogbrokerWriteRequest(jsonRequest.getBytes(UTF_8));
    }

}
