package ru.yandex.direct.binlogbroker.logbroker_utils.writer;

import java.time.Duration;

public class LogbrokerWriterRetryConfig {

    private final int retryCount;
    private final Duration retryDelay;

    private static final int DEFAULT_RETRY_COUNT = 0;
    private static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(5);

    public LogbrokerWriterRetryConfig(int retryCount, Duration retryDelay) {
        this.retryCount = retryCount;
        this.retryDelay = retryDelay;
    }

    public LogbrokerWriterRetryConfig(int retryCount) {
        this(retryCount, DEFAULT_RETRY_DELAY);
    }

    public int getRetryCount() {
        return retryCount;
    }

    public Duration getRetryDelay() {
        return retryDelay;
    }

    public static LogbrokerWriterRetryConfig defaultConfig() {
        return new LogbrokerWriterRetryConfig(DEFAULT_RETRY_COUNT, DEFAULT_RETRY_DELAY);
    }
}
