package ru.yandex.direct.binlogbroker.replicatetoyt;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.common.GUID;

/**
 * Реализация сохранения offset'а от логброкера, которая на самом деле ничего не делает.
 */
@ParametersAreNonnullByDefault
public class DummyStateManager implements StateManager {
    public static final DummyStateManager INSTANCE = new DummyStateManager();
    public static final ShardOffsetSaver SHARD_OFFSET_SAVER = new ShardOffsetSaver() {
        @Override
        public void save() {
            // do nothing
        }

        @Override
        public void save(GUID tx) {
            // do nothing
        }
    };

    private DummyStateManager() {
    }

    @Override
    public Optional<Long> getShardOffset(String source) {
        return Optional.empty();
    }

    @Override
    public ShardOffsetSaver shardOffsetSaver(String source, long offset) {
        return SHARD_OFFSET_SAVER;
    }
}
