package ru.yandex.direct.binlogbroker.replicatetoyt;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.common.GUID;

/**
 * Интерфейс, предназначенный для чтения и записи offset'а от логброкера.
 */
@ParametersAreNonnullByDefault
public interface StateManager {
    /**
     * Получение offset для определённого источника, если такой offset записан.
     * Источник - см. SourceType.getSourceName().
     */
    Optional<Long> getShardOffset(String source);

    /**
     * Установить на директорию с шардом атрибут, в котором записан offset. Offset приезжает
     * вместе с записями из логброкера (внутри топика он строго возрастает). Используется для
     * проверки того, нужно ли обрабатывать конкретный {@link ru.yandex.direct.binlog.model.BinlogEvent}.
     *
     * @param source Название шарда.
     * @param offset Смещение, которое следует записать.
     */
    ShardOffsetSaver shardOffsetSaver(String source, long offset);

    interface ShardOffsetSaver {
        /**
         * Сохранить offset немедленно.
         */
        void save();

        /**
         * Сохранить offset в транзакции YT. Если транзакцию откатить, то и сохранённый offset будет откачен.
         */
        void save(GUID tx);
    }
}
