package ru.yandex.direct.binlogbroker.replicatetoyt;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;

@ParametersAreNonnullByDefault
public class YtAttrStateManager implements StateManager {
    private static final String STATE_ATTR = "previous_offset";
    private final Yt yt;
    private final YPath tablesDir;

    public YtAttrStateManager(Yt yt, YPath tablesDir) {
        this.yt = yt;
        this.tablesDir = tablesDir;
    }

    private YPath getAttr(String source) {
        return tablesDir.child(source).attribute(STATE_ATTR);
    }

    /**
     * Получить offset соответствующий последнему {@link ru.yandex.direct.binlog.model.BinlogEvent},
     * обработанному в данном шарде. Используется для проверки того, нужно ли обрабатывать
     * конкретный {@link ru.yandex.direct.binlog.model.BinlogEvent}.
     */
    @Override
    public Optional<Long> getShardOffset(String source) {
        YPath attr = getAttr(source);
        if (!yt.cypress().exists(attr)) {
            return Optional.empty();
        }
        return Optional.of(yt.cypress().get(attr).longValue());
    }

    @Override
    public ShardOffsetSaver shardOffsetSaver(String source, long offset) {
        return new ShardOffsetSaver() {
            @Override
            public void save() {
                yt.cypress().set(getAttr(source), YTree.integerNode(offset));
            }

            @Override
            public void save(GUID tx) {
                yt.cypress().set(Optional.of(tx), false, getAttr(source), YTree.integerNode(offset));
            }
        };
    }
}
