package ru.yandex.direct.binlogbroker.replicatetoyt;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.model.BinlogEvent;

@ParametersAreNonnullByDefault
public interface YtReplicator {
    String SOURCE_COLUMN_NAME = "__source__";
    String HASH_COLUMN_NAME = "__hash__";

    // Дефолтное кол-во партиций (таблетов) новой (создаваемой через CREATE TABLE) таблицы
    int DEFAULT_PARTITIONS_COUNT = 32;

    void acceptDDL(BinlogEvent binlogEvent, StateManager.ShardOffsetSaver shardOffsetSaver)
            throws InterruptedException;

    void acceptDML(List<BinlogEvent> binlogEvents, StateManager.ShardOffsetSaver shardOffsetSaver)
            throws InterruptedException;
}
