package ru.yandex.direct.binlogbroker.replicatetoyt.configuration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.binlogbroker.replicatetoyt.YtReplicator;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.ytwrapper.client.YtClusterConfig;
import ru.yandex.direct.ytwrapper.client.YtClusterTypesafeConfigProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;
import ru.yandex.yt.ytclient.bus.BusConnector;
import ru.yandex.yt.ytclient.bus.DefaultBusConnector;
import ru.yandex.yt.ytclient.proxy.YtClient;
import ru.yandex.yt.ytclient.rpc.RpcCredentials;
import ru.yandex.yt.ytclient.rpc.RpcOptions;

/**
 * Класс описывает, как создавать бины, которые нужны,
 * чтобы создать {@link YtReplicator}
 * Перед использованием необходимо зарегистрировать бин ytCluster типа YtCluster
 */
@Configuration
@ParametersAreNonnullByDefault
public abstract class YtReplicatorConfiguration {

    /**
     * кластер, в который надо писать.
     */
    @Bean
    public abstract YtCluster ytCluster();

    @Bean
    @Lazy
    public YtClusterConfig ytClusterConfig(YtCluster ytCluster) {
        return new YtClusterTypesafeConfigProvider(DirectConfigFactory.getConfig().getBranch("yt").getConfig())
                .get(ytCluster);
    }

    @Bean(destroyMethod = "close")
    @Lazy
    public BusConnector busConnector() {
        return new DefaultBusConnector();
    }

    @Bean(destroyMethod = "close")
    @Lazy
    public YtClient ytClient(YtClusterConfig ytClusterConfig, BusConnector busConnector) {
        final RpcCredentials rpcCredentials =
                new RpcCredentials(ytClusterConfig.getUser(), ytClusterConfig.getToken());
        YtClient ytClient = null;
        try {
            ytClient = new YtClient(busConnector,
                    new ru.yandex.yt.ytclient.proxy.YtCluster(
                            ytCluster().getName(), ytClusterConfig.getProxyHost(), ytClusterConfig.getProxyPort()),
                    rpcCredentials, new RpcOptions());
            ytClient.waitProxies().join(); // IGNORE-BAD-JOIN DIRECT-149116
        } catch (RuntimeException e) {
            if (ytClient != null) {
                ytClient.close();
            }
            throw e;
        }
        return ytClient;
    }

    @Bean
    @Lazy
    public Yt yt(YtClusterConfig ytClusterConfig) {
        return YtUtils.http(ytClusterConfig.getProxy(), ytClusterConfig.getToken());
    }
}
