package ru.yandex.direct.binlogbroker.logbrokerwriter;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.ParameterException;
import org.slf4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.direct.binlogbroker.logbrokerwriter.components.BinlogbrokerSupervisor;
import ru.yandex.direct.binlogbroker.logbrokerwriter.configuration.BinlogbrokerConfiguration;
import ru.yandex.direct.binlogbroker.logbrokerwriter.jcommander.BinlogbrokerToolParameters;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;

/**
 * Приложение - входная точка синхронизатора бинлогов в логброкер.
 */
@ParametersAreNonnullByDefault
public class BinlogbrokerTool {
    private static final Logger logger = LoggingInitializer.getLogger(BinlogbrokerTool.class);
    private static final String SERVICE_NAME = "direct.binlogbroker";

    private BinlogbrokerTool() {
    }

    public static void main(String[] args) throws InterruptedException {
        BinlogbrokerToolParameters parameters = new BinlogbrokerToolParameters();

        ParserWithHelp.parse(
                BinlogbrokerTool.class.getCanonicalName(),
                args,
                parameters);
        try {
            parameters.validateAndFillDefaults();
        } catch (ParameterException exc) {
            ParserWithHelp.printErrorAndExit(exc);
        }

        LoggingInitializer.initialize(parameters.loggingInitializerParams, SERVICE_NAME);
        BinlogbrokerConfiguration.initializeStaticData(parameters);

        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(
                BinlogbrokerConfiguration.class)) {
            ((BinlogbrokerSupervisor) context.getBean("binlogbrokerSupervisor")).run();
        } catch (Throwable e) {
            logger.error("Unexpected exception in main", e);
            throw e;
        }
    }
}
