package ru.yandex.direct.binlogbroker.logbrokerwriter.components;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import ru.yandex.direct.binlog.model.BinlogQuery;
import ru.yandex.direct.binlogbroker.logbrokerwriter.models.BinlogWithSeqId;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;

public class BinlogLogbrokerQueryWriter extends BinlogLogbrokerWriter {
    public BinlogLogbrokerQueryWriter(
            Supplier<CompletableFuture<AsyncProducer>> asyncProducerSupplier,
            Duration logbrokerTimeout, int retries,
            DataFormat dataFormat)
    {
        super(asyncProducerSupplier, logbrokerTimeout, retries, dataFormat);
    }

    @Override
    public LogbrokerWriteRequest makeRequest(BinlogWithSeqId record) {
        byte[] bytesToWrite;
        BinlogQuery binlogQuery = new BinlogQuery(
            record.event.getUtcTimestampAsEpochSecond(),
            record.event.getSource(),
            record.event.getServerUuid(),
                record.event.getTransactionId(),
                record.event.getQueryIndex(),
                record.event.getQuery(),
                record.event.getTraceInfoReqId(),
                record.event.getTraceInfoService(),
                record.event.getTraceInfoMethod(),
                record.event.getTraceInfoOperatorUid()
        );
        if (getDataFormat() == DataFormat.JSON) {
            bytesToWrite = JsonUtils.toJsonBytes(binlogQuery);
        } else {
            throw new IllegalArgumentException("data format not supported: " + getDataFormat().toString());
        }
        // используем seqId от события. Одному запросу могут соответствовать несколько событий, поэтому в seqId для запросов могут быть пропуски.
        return new LogbrokerWriteRequest(bytesToWrite, record.seqId);
    }
}
