package ru.yandex.direct.binlogbroker.logbrokerwriter.components;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.SourceType;

/**
 * Имитация глобальной блокировки, которая на самом деле ничего никогда не блокирует.
 */
@ParametersAreNonnullByDefault
public class DummyGuardFactory implements SourceGuardFactory {
    private static final SourceGuard DUMMY = () -> { /* dummy guard closes nothing */ };

    @Override
    public Optional<SourceGuard> guard(SourceType source) {
        return Optional.of(DUMMY);
    }
}
