package ru.yandex.direct.binlogbroker.logbrokerwriter.components;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.SourceType;

/**
 * Позволяет взять глобальную блокировку для определённого источника изменений. Предназначено для того,
 * чтобы избежать работы двух синхронизаторов одного источника в один приемник.
 */
@FunctionalInterface
@ParametersAreNonnullByDefault
public interface SourceGuardFactory {
    /**
     * Попытаться взять лок для определённого источника. Блокирования потока либо нет, либо оно настолько мало,
     * насколько позволяют используемые в реализации инструменты.
     *
     * @param source Источник, для которого следует взять лок.
     * @return {@link SourceGuard}, если удалось взять лок. {@link Optional#empty()}, если не удалось.
     */
    Optional<SourceGuard> guard(SourceType source);
}
