package ru.yandex.direct.binlogbroker.logbrokerwriter.components;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.SourceType;
import ru.yandex.direct.binlogbroker.logbrokerwriter.models.ImmutableSourceState;

/**
 * Загрузка и сохранение состояния
 * {@link ru.yandex.direct.binlogbroker.logbrokerwriter.components.Binlogbroker Binlogbroker}.
 */
@ParametersAreNonnullByDefault
public interface SourceStateRepository extends AutoCloseable {

    ImmutableSourceState loadState(SourceType source);

    void saveState(SourceType source, ImmutableSourceState sourceState);

    default String getClusterName() {
        return null;
    }
}
