package ru.yandex.direct.binlogbroker.logbrokerwriter.jcommander;

import java.util.List;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;

import ru.yandex.direct.env.Environment;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.logging.LoggingInitializerParams;

/**
 * Аргументы командной строки для
 * {@link ru.yandex.direct.binlogbroker.logbrokerwriter.BinlogbrokerTool BinlogbrokerTool}.
 */
@SuppressWarnings("checkstyle:visibilitymodifier")
public class BinlogbrokerToolParameters {

    @Parameter(
            names = {"--db-config-env"},
            description = "Environment of MySQL servers.",
            converter = EnvironmentTypeConverter.class
    )
    public EnvironmentType dbConfigEnv;

    @Parameter(
            names = {"--logbroker-source-id-prefix"},
            description = "Some string that will be prepended to source id"
    )
    public String logbrokerSourceIdPrefix = "";

    @Parameter(
            names = {"--shards"},
            description = "Comma separated list of shard, e.g.: 1,2,3,4"
    )
    public List<Integer> shards;

    @Parameter(
            names = {"--dont-truncate-fields"},
            description = "List of fields to not truncate from binlog. Example: \"phrases.cid,banners.pid\""
    )
    public String dontTruncateFields;

    @ParametersDelegate
    public LoggingInitializerParams loggingInitializerParams = new LoggingInitializerParams();

    public void validateAndFillDefaults() {
        if (dbConfigEnv == null) {
            dbConfigEnv = Environment.getCached();
        }
    }
}
