package ru.yandex.direct.binlogbroker.logbrokerwriter.jcommander;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;

import ru.yandex.direct.env.EnvironmentType;

public class EnvironmentTypeConverter extends BaseConverter<EnvironmentType> {
    public EnvironmentTypeConverter(String optionName) {
        super(optionName);
    }

    @Override
    public EnvironmentType convert(String value) {
        try {
            return EnvironmentType.valueOf(value.trim().toUpperCase());
        } catch (IllegalArgumentException exc) {
            throw new ParameterException(getErrorString(value, "environment type"));
        }
    }
}
