package ru.yandex.direct.binlogbroker.logbrokerwriter.models;

import java.util.Objects;

import ru.yandex.direct.binlog.model.BinlogEvent;


/**
 * Simple placeholder for pair of Logbroker seqId and BinlogEvent to be written to Logbroker.
 */
@SuppressWarnings("checkstyle:visibilitymodifier")
public class BinlogWithSeqId {
    public final long seqId;
    public final BinlogEvent event;

    public BinlogWithSeqId(long seqId, BinlogEvent event) {
        this.seqId = seqId;
        this.event = event;
    }

    @Override
    public String toString() {
        return "BinlogWithSeqId{" +
                "seqId=" + seqId +
                ", event=" + event +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinlogWithSeqId)) {
            return false;
        }
        BinlogWithSeqId that = (BinlogWithSeqId) o;
        return seqId == that.seqId &&
                Objects.equals(event, that.event);
    }

    @Override
    public int hashCode() {
        return Objects.hash(seqId, event);
    }
}
