package ru.yandex.direct.binlogbroker.logbrokerwriter.models;

import java.nio.file.Paths;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.utils.io.FileUtils;

@ParametersAreNonnullByDefault

public class LogbrokerCredentialsConfig {
    private String tvmTokenPath = null;

    @Parameter(
            names = {"--logbroker-tvm-token-path"}
    )
    public void setTvmTokenPath(String tvmTokenPath) {
        this.tvmTokenPath = tvmTokenPath;
    }

    @Nullable
    public String getTvmToken() {
        if (this.tvmTokenPath == null) {
            return null;
        } else {
            return FileUtils.slurp(Paths.get(this.tvmTokenPath)).trim();
        }
    }

}
