package ru.yandex.direct.binlogbroker.logbrokerwriter.models;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlogbroker.logbroker_utils.models.SourceType;
import ru.yandex.direct.db.config.DbConfig;
import ru.yandex.direct.db.config.DbConfigFactory;
import ru.yandex.direct.db.config.DbConfigListener;

@ParametersAreNonnullByDefault
public class SourceDbConfigs {
    private final Set<SourceType> availableSourceTypes;
    private final DbConfigFactory dbConfigFactory;

    public SourceDbConfigs(Set<SourceType> availableSourceTypes, DbConfigFactory dbConfigFactory) {
        this.availableSourceTypes = availableSourceTypes;
        this.dbConfigFactory = dbConfigFactory;
    }

    public Supplier<DbConfig> getMysqlConnector(SourceType source) {
        return () -> dbConfigFactory.get(source.getDbName());
    }

    public Collection<SourceType> getSources() {
        return availableSourceTypes;
    }

    public void addListener(DbConfigListener listener) {
        dbConfigFactory.addListener(listener);
    }
}
